// Blaze Guardian
BlockEvents.rightClicked('minecraft:spawner', event => {
    const {item, block, hand, level} = event
    const {x, y, z} = block
    if (hand != "MAIN_HAND") return
    if (item.id == 'lote:blazing_geode' && block.dimension == 'minecraft:the_nether') {
        let entityData = block.entityData.toString()
        if (!entityData.includes('minecraft:blaze')) return
        item.count--
        event.server.scheduleInTicks(2, (_) => {
            let entity = level.createEntity('adventurez:blaze_guardian')

            entity.addTag('Boss')
            entity.setMaxHealth(120)
            entity.setHealth(120)
            entity.x = x
            entity.y = y+1
            entity.z = z
            entity.spawn()
            })
    }
})

BlockEvents.rightClicked('voidz:void_portal', event => {
    const {player} = event
    if (!player.stages.has('voidz_unlocked')){   //Given by quest
        title(player.username, '')
        subtitle(player.username, 'A powerful force repels you.', 'red')
        actionbar(player.username, 'Perhaps you need to research more about this world to continue.')
        event.cancel()
    }
})

// Soul Pedestal Nether Check
BlockEvents.rightClicked('spirit:soul_pedestal', event => {
    const {block, player, entity} = event

})

BlockEvents.rightClicked('adventurez:shadow_chest_block', event => {
    let player = event.player
    if(!player.stages.has('void_beaten')){
        player.stages.add('void_beaten')
        player.data.ftbquests.addProgress('04B38C1B21E9AF83',1)
        player.tell('Peace spreads across the world and finally, your task has ended.')
        player.tell('A rite gone wrong, now set right. You have mastered The Legend of the Eyes!!!')
}
})

BlockEvents.placed('minecraft:dragon_egg', event => {
    const {block, level} = event
    if (level.dimension != 'minecraft:the_end'){
        let dataTemp = block.entityData
        dataTemp.Hatch_Able = 1
        dataTemp.Hatch_Tick = 570
        block.entityData = dataTemp
    }
})

// Summoning Rituals
SummoningRituals.start(event => {
    const {level, recipe, player}  = event
    if (recipe.id == 'lote:necromancer_soulreaper' && level.dimension != 'minecraft:the_nether'){
        actionbar(player.username, `This Ritual does not want to work here.`)
        event.cancel()
        return
    }
    if (recipe.id == 'lote:elder_guardian' && !player.isUnderWater()) {
        actionbar(player.username, `This Ritual only works underwater.`)
        event.cancel()
        return
    }
    if (recipe.id == 'lote:pharaoh' && player.block.biomeId != 'minecraft:desert') {
        actionbar(player.username, `This Ritual only works in the Desert.`)
        event.cancel()
        return
    }
})

ItemEvents.entityInteracted('adventurez:dragon', event => {
    const {target, item} = event
    if (item == 'lote:magic_dragon_scale'){
        let nbt = target.fullNBT
        if (nbt.RedDragon == 1) nbt.RedDragon = 0
        else nbt.RedDragon = 1
        target.fullNBT = nbt
    }
})

ItemEvents.entityInteracted(event =>{
    const {player, target, hand, server } = event

    if (hand != "MAIN_HAND") return;

    let mainHand = player.getMainHandItem()

    switch (target.type) {

        //Fungus quest
        case ('adventurez:brown_fungus'):   //continues to red_fungus's
        case ('adventurez:red_fungus'): {
            let length = flowers.length
            let randomInt = Math.floor(Math.random() * length)
            let randomFlower = flowers[randomInt]

            if(!player.stages.has('fungus_flower')){
                player.persistentData.fungusFlower = randomFlower
                player.stages.add('fungus_flower')
            }

            if(player.persistentData.fungusFlower){
                if (mainHand == 'air') {
                    title(player.username,"The Fungus Spore!")
                    subtitle(player.username, "Bring them a flower!")
                    player.tell(`§2Fungus§r: ${player.username}, Please bring me a ${player.persistentData.fungusFlower[1]} for one of my Spores.`)
                } else if (mainHand == player.persistentData.fungusFlower[0]){
                    mainHand.count--
                    player.giveInHand('lote:mushroom_spore')
                    player.stages.remove('fungus_flower')
                    title(player.username, 'Quest Complete!')
                    subtitle(player.username, `That's one happy fungi`)

                    delay(5, player.tell(`§2Fungus§r: ${player.username}, thank you for bringing me the ${player.persistentData.fungusFlower[1]}.`))
                    delay(10, player.tell(`§2Fungus§r: Have one of my Spores. It might help you in your journey.`))
                    delay(160, player.tell(`${player.username}: I should consult my journal to find out what I need these Spores for.`))
                }
            }
            break
        }

        //Allay quest
        case ('minecraft:allay'): {
            let randomCoral = coral[Math.floor(Math.random() * coral.length)]
            let choice = variation[Math.floor(Math.random() * variation.length)]

            if(!player.stages.has('coral')){
                player.persistentData.coralItem = `minecraft:${randomCoral}_coral${choice}`
                player.stages.add('coral')
            }

            if(player.persistentData.coralItem){
                let nbt = target.fullNBT
                if (mainHand == 'air') {
                    if (player.persistentData.coraltimer == 0 && nbt.HandItems[0].id == 10){
                        player.persistentData.coraltimer = 300
                        title(player.username,"Exotic Allay!")
                        subtitle(player.username, "Have you been to a warm Ocean yet?!")
                        player.tell(Text.of(`§2Allay§r: ${player.username}, I have never been to an Ocean. Could you bring me a `).append(Item.of(player.persistentData.coralItem).hoverName).append(`?`))
                    }
                } else if (mainHand == player.persistentData.coralItem){
                    event.cancel()
                    mainHand.count--
                    server.runCommandSilent(`particle adventurez:amethyst_shard_particle ${target.x} ${target.y+0.2} ${target.z} 0 0 0 0.5 200 force`)
                    target.fullNBT = nbt
                    player.giveInHand('endrem:exotic_eye')
                    player.stages.remove('coral')
                    player.stages.remove('pickUpCoral')
                    player.persistentData.coraltimer = 1200
                    title(player.username, 'One Happy Allay!')
                    subtitle(player.username, 'A Coral for an Eye')

                    delay(5, player.tell(`§2Allay§r: Thanks! Here, have something I have been carrying for a long time.`))
                    delay(25, player.tell(`§2Allay§r: Isn't it pretty? I hope it will help you in your journey.`))
                }
            }
            break
        }

        //Witch quest
        case ('minecraft:witch'): {
            // /summon minecraft:witch ~ ~ ~ {NoAI:1, Tags:["witchhut"]}
            if (mainHand != 'lote:mushroom_brew') return;
            let tags = target.fullNBT?.Tags.toString() ?? 'None'
            if (tags.includes('witchhut')){
                let {x, y, z} = target
                event.server.runCommandSilent(`execute in minecraft:overworld run particle minecraft:cloud ${x} ${y+1} ${z} 0.5 0.5 0.5 0.2 750 normal`)
                target.discard()
                player.tell(`§2Shaman§r: ${player.username}, HA! You thought this could kill me!?`)
                event.server.runCommandSilent(`execute in minecraft:overworld run summon adventurez:shaman ${x} ${y} ${z} {Tags:["Boss"]}`)
                title(player.username, `I'm sorry, but this will hurt.`)
                delay(10, player.tell(`§2Shaman§r: This only made me stronger than ever before!`))
                delay(20, player.tell(''))
                delay(160, player.tell(`§2Shaman§r: Face my Wrath!`))
            }
            break
        }

        //Lost Eye
        case ('minecraft:villager'): {
            if (
                mainHand == 'advancednetherite:netherite_emerald_ingot' &&
                player.potionEffects.isActive('minecraft:hero_of_the_village')
            ){
                event.cancel()
                server.scheduleInTicks(2,(_) => {
                    mainHand.count--
                    player.giveInHand(Item.of('endrem:lost_eye').enchant('yigd:soulbound', 1))
                    server.runCommandSilent(`effect clear ${player.username} minecraft:hero_of_the_village`)
                    player.tell(`&eVillager&r: Thanks for saving our Village! Have this as a reward!`)
                })
            }
            break
        }
    }
})

// Deathcounter for cursed eye
EntityEvents.death((event) =>{
    // Deathcounter for Cursed Eye
    let player = event.entity
    if (!player.isPlayer()) return
    if (!player.persistentData.cursed == 1) return
    player.persistentData.deathcounter++
})

//Voidz boss hint
EntityEvents.death((event) =>{
    let killed = event.entity
    let player = event.source.getActual()

    if (killed.toString().contains('Void Shade') && player.isPlayer()) {
        if (!player.persistentData.voidShadesKilled) {
            player.persistentData.voidShadesKilled = 1
        }
        if (player.persistentData.voidShadesKilled) {
            player.persistentData.voidShadesKilled++
            switch (player.persistentData.voidShadesKilled) {
                case 7:
                    player.tell('Looks like killing these isn\'t doing anything.')
                    break
                case 12:
                    player.tell('I should try something else.')
                    break
            }
        }
    }
})


EntityEvents.hurt((event) => {
    let player = event.entity
    if (!player.isPlayer()) return
    let source = event.source.toString()

    // Magical Eye song invulnerability
    if (!player.persistentData.horn == 1 && source.toString().includes('DamageSource (lightningBolt)' || 'DamageSource (onFire)' || 'DamageSource (inFire)')) {
        event.cancel
    }

    //Voidz boss hint
    if (source.includes('Void Bullet')) {

        if (!player.persistentData.hitByVoidzBullet) {
            player.persistentData.hitByVoidzBullet = 1
        }
        if (player.persistentData.hitByVoidzBullet) {
            player.persistentData.hitByVoidzBullet++
            if (player.persistentData.hitByVoidzBullet == 5) {
                player.tell('Maybe I could reflect these projectiles?')
            } else {
                if (player.persistentData.hitByVoidzBullet % 5 == 0 && player.persistentData.hitByVoidzBullet != 5) {
                    player.tell('I should reflect these projectiles at the Void Fragments at the edge of the arena!')
                }
            }
        }
    }
})

// Magical Eye
ItemEvents.rightClicked('lote:goat_horn', event =>{
    const {player, server, item} = event
    const {x, y, z} = player

    // Only allow 1 time play
    if (item.nbt == '{played:1}') {
        actionbar(player.username, 'This horn seems broken.')
        return
    }
    if(item.nbt == null) {
        item.nbt = "{played:1}"
        player.tell('A mighty boom bellows from the horn.')
        player.tell('The horn feels lighter, somehow.')
    }

    player.swing()
    if (player.persistentData?.horn == 0) player.persistentData.horn = 1
    player.addItemCooldown('lote:goat_horn', 500)
    player.runCommandSilent(`execute at ${player.username} run playsound lote:horn master ${player.username}`)
    player.runCommandSilent(`execute at ${player.username} run weather thunder`)

    server.scheduleInTicks(100, (_) =>{
        for(let i = 0; i <= 7; i++){
            for(let r = 1; r <= 4; r++){
                let randomx = Math.floor(getRandomInt(1, 9))
                let randomz = Math.floor(getRandomInt(1, 9))
                switch (r){
                    case 1:
                        server.scheduleInTicks(i*r*10, (_) => player.runCommandSilent(`execute at ${player.username} run summon minecraft:lightning_bolt ${x+randomx} ${y} ${z+randomz}`))
                        break
                    case 2:
                        server.scheduleInTicks(i*r*10, (_) => player.runCommandSilent(`execute at ${player.username} run summon minecraft:lightning_bolt ${x-randomx} ${y} ${z-randomz}`))
                        break
                    case 3:
                        server.scheduleInTicks(i*r*10, (_) => player.runCommandSilent(`execute at ${player.username} run summon minecraft:lightning_bolt ${x+randomx} ${y} ${z-randomz}`))
                        break
                    case 4:
                        server.scheduleInTicks(i*r*10, (_) => player.runCommandSilent(`execute at ${player.username} run summon minecraft:lightning_bolt ${x-randomx} ${y} ${z+randomz}`))
                        break
                }
            }
        }
    })
    server.scheduleInTicks(400, (_) => player.persistentData.horn = 0)
    for (let i = 0; i < 10; i++){
        server.scheduleInTicks(490+(i*10), (_) => event.server.runCommandSilent(`execute at ${player.username} run particle minecraft:ambient_entity_effect ${player.x} ${player.y+4} ${player.z} 0.5 1 0.5 0.5 100 force`))
    }
    server.scheduleInTicks(500, (_) => event.server.runCommandSilent(`execute at ${player.username} run summon item ${player.x} ${player.y+4} ${player.z} {Item:{id:"endrem:magical_eye",Count:1b},NoGravity:1b}`))
})

ItemEvents.rightClicked('ftbquests:book', event =>{
    const {player, hand} = event
    if (hand != "MAIN_HAND") return;
    if(!player.isCrouching()) return
    event.cancel()
    if (player.stages.has('coral')) {
        player.tell(Text.of(`§2${player.username}§r: If I remember correctly, the Allay wanted me to get a `).append(Item.of(player.persistentData.coralItem).hoverName).append(`.`))
    }
    if (player.stages.has('fungus_flower')){
        player.tell(`§2${player.username}§r: These Fungi wanted me to get them a ${player.persistentData.fungusFlower[1]}.`)

    }
})

// Disable Firework Rockets
ItemEvents.rightClicked('minecraft:firework_rocket', event => {
    const {player} = event
    if (player.persistentData.eyecounter <= 11){
        event.cancel()
        if (player.getChestArmorItem().toString().contains('elytra') ||
            player.getChestArmorItem().toString().contains('modular')) player.tell('The Rocket fails to ignite.')
    }
})

// Disable ender throw
ItemEvents.rightClicked(eyes, event => {
    const {player, block} = event
    event.cancel()
    player.tell(`${player.username}: I shouldn't be throwing this Eye, its way to important.`)
})

// Horse Summoning
ItemEvents.rightClicked('supplementaries:flute', event => {
    const {player, level, item} = event
    if (item.nbt.contains('Pet')) return
    let pData = player.persistentData
    if (pData.horsetimer != 0) {
        event.server.scheduleInTicks(100, (_) => {
            actionbar(player.username, `It seems your horse is no where to be found`)
        })
    }
    if (pData.horsetimer == 0){
        pData.horsetimer = 6000
        event.server.scheduleInTicks(100, (_) => {
            const {x,y,z} = player
            let offsetx = getRandomInt(-3, 3)
            let offsetz = getRandomInt(-3, 3)
            let entity = level.createEntity('minecraft:horse')
            entity.fullNBT = `{Tame:1,SaddleItem:{id:saddle,Count:1}}`
            entity.x = x+offsetx
            entity.y = y
            entity.z = z+offsetz
            entity.spawn()
        })
    }
})


PlayerEvents.loggedIn((event) => {
    const {player} = event
    let pData = player.persistentData

    pData.stagetimer = 0
    pData.coraltimer = 0
    pData.horsetimer = 0
    pData.pharaohtimer = 0

    
    if (pData?.spawn == undefined){
        pData.spawn = {}
        pData.spawn.x = Math.floor(player.x)
        pData.spawn.y = Math.floor(player.y)
        pData.spawn.z = Math.floor(player.z)
    }

    if (pData?.hearts == undefined) pData.hearts = 20
    if (pData?.horn == undefined) pData.horn = 0
    if (pData?.deathcounter == undefined) pData.deathcounter = 0
    if (pData?.cursed == undefined){
        pData.cursed = 0
        pData.cursetimer == 0.0}
    if (pData?.eyecounter == undefined) pData.eyecounter = 0

    if (pData.eyecounter >= 12 && !player.stages.has('rocket_enabled')) player.stages.add('rocket_enabled')
    let difficulty = event.level.getDifficulty()
    if (difficulty == 'PEACEFUL') pData.cursed = 2
    if (difficulty == "EASY") pData.deathtrigger = 5
    if (difficulty == "NORMAL") pData.deathtrigger = 10
    if (difficulty == "HARD") pData.deathtrigger = 25
    if (difficulty == "HARDCORE") pData.deathtrigger = 1
})

PlayerEvents.tick((event) => {
    let player = event.player
    let pData = player.persistentData

    pData.stagetimer++
    //prevents all ofthese update checks from happening too often
    if (pData.stagetimer % 20 != 0) return
    

    let tags = player.fullNBT?.Tags ?? 'none'
    let potion = player.potionEffects
    let sec = 20
    let deathtrigger = 10

    if (pData.cursed == 1) pData.cursetimer++
    if (pData.cursetimer == (NaN || undefined)) pData.cursetimer = 0
    if (pData.coraltimer != 0) pData.coraltimer--
    if (pData.horsetimer != 0) pData.horsetimer--
    if (pData.pharaohtimer != 0) pData.pharaohtimer--

    // Get Hearts Modifiers
    let attributes = player.fullNBT?.Attributes
    let healthAttr = attributes.find(e => e.Modifiers != null)
    let healthMods = healthAttr.Modifiers.find(e => e.Amount != null)
    let modifierAmount = healthMods.Amount


    if (player.getMaxHealth() < (pData.hearts+modifierAmount)) {
        player.setMaxHealth(pData.hearts)
        player.setAttributeBaseValue('minecraft:generic.max_health', pData.hearts)
    }


    // Random Curse Effect Pyramid
    if (pData.cursed == 1 && pData.cursetimer > sec){
        let randomNegEffect = negEffects[getRandomInt(0, negEffects.length)]
        let effectName = capFirst(randomNegEffect[0].split(':')[1].replace('_', ' '))
        actionbar(player.username, `Currently cursed with ${effectName}`)
        potion.add(randomNegEffect[0], randomNegEffect[1]*sec, randomNegEffect[2], false, false)
        pData.cursetimer = 0
    }
    if(player.stages.has('pharaoh_beaten') && pData.cursed <2) pData.cursed = 2

    // Pity Event Cursed Eye
    if (pData.deathcounter >= deathtrigger && pData.cursed == 1 && player.alive == true){
        pData.cursed = 2
        title('Pity...')
        subtitle(player.username, 'The Pharaoh has taken a pity on you')
        player.tell(`§2Pharaoh§r: Can't even survive my curses? Begone, and take my eye! I don't want to see you ever again!`)
        if (difficulty == "EASY"){
            player.giveInHand('minecraft:enchanted_golden_apple')
            delay(60, player.tell(`§2Pharaoh§r: Already playin on Easy? Take a Notch apple. Clearly I can't make it any easier for you.`))

        }
        if (difficulty == "HARDCORE"){
            gameOver()
        }
    }

    
    if (
        !player.stages.has('end_access') &&
        player.level.dimension == 'minecraft:the_end' &&
        player.stages.has('starting_items')
    ) {
        let x = player.fullNBT?.SpawnX ?? pData.spawn.x
        let y = player.fullNBT?.SpawnY ?? pData.spawn.y
        let z = player.fullNBT?.SpawnZ ?? pData.spawn.z
        player.teleportTo(
            'minecraft:overworld',
            x,
            y,
            z,
            player.yaw,
            player.pitch
        )
        player.tell('A powerful force prevents you from entering the End...')
    }
    

    if(player.stages.has('killed_dragon') && !potion.isActive('adventurez:fame')){
        event.server.runCommandSilent(`effect give ${player.username} adventurez:fame 999999 0 true`)
    }

    //Lost Eye quests
    if (potion.isActive('minecraft:bad_omen') && !player.stages.has('bad_omen')){
        player.stages.add('bad_omen')
    }
    if (potion.isActive('minecraft:hero_of_the_village') && !player.stages.has('hero_of_the_village')){
        player.stages.add('hero_of_the_village')
    }

    
    pData.stagetimer = 0
})

ItemEvents.pickedUp(event =>{
    const {item,player} = event
    if (player.stages.has('coral') && !player.stages.has('pickUpCoral')){
        if (item.id == player.persistentData.coralItem){
            player.tell(`I think this item is what the Allay was looking for!`)
            player.stages.add('pickedUpCoral')
        }
    }
    
    if (player.stages.has('fungus_flower') && !player.stages.has('pickedUpFlower')){
        if (item.id == player.persistentData.fungusFlower){
            player.tell(`Hey! I think that fungus person wanted this flower!`)
            player.stages.add('pickedUpFlower')
        }

    }

})

PlayerEvents.inventoryChanged(event => {
    const { block, item, player, level, server, target, entity } = event
    // Cursed Eye pickup
    if (item.id == 'endrem:cursed_eye'){
        if (player.persistentData.cursed >= 1) return
        title(player.username, "☠ You have been cursed ☠")
        subtitle(player.username, "Kill the Pharaoh to lift the curse!")
        player.persistentData.cursed = 1
        }
    // Gain health on first pickup
    if (eyes.includes(item.id)) {
        adjHealth(event, item.id)
        if (player.persistentData.eyecounter >= 12 && !player.stages.has('rocket_enabled')){
            player.stages.add('rocket_enabled')
            player.tell(`${player.username}: I think I should try and use some rockets again`)
        }
    }
})

//block vanilla Eyes
BlockEvents.rightClicked('endrem:ancient_portal_frame', event => {
    const {player,item} = event

    if (item == 'minecraft:ender_eye') {
        player.tell('It seems this Eye cannot fit into the Frame')
        event.cancel()
    }
})

//Milk Giraffes
ItemEvents.entityInteracted(event => {
    const {item, player, target} = event
    if (target.type == 'creatures_from_the_snow:giraffe' && item.id == "minecraft:bucket"){
        item.count--
        player.giveInHand(Item.of('minecraft:milk_bucket', "{display:{Name:'{\"text\":\"Giraffe Milk Bucket\"}'}}"))
    }
})

//Lunchbox Event Cancel when hunger full
ItemEvents.rightClicked(event => {
    const {hand, item, player} = event
    if (player.isCrouching() == false &&
        hand == "MAIN_HAND" &&
        item.id == 'spiceoffabric:lunch_box' &&
        player.foodLevel >= 20) event.cancel()
})

EntityEvents.death(event => {
    const {entity, level} = event
    if(entity.isPlayer()){
        let {x, y, z} = entity
        let area = 256
        let entities = level.getEntitiesWithin(AABB.of(x-area, y-area, z-area, x+area, y+area, z+area))
        //forEach entity
        entities.forEach((mob) => {
            // Return if entity isnt living
            if(!mob.isLiving()) return
            if(mob.toString().contains('Wither')) mob.invulnerable = false
            }
        )
    }
})

FTBQuestsEvents.completed('08139ADE3F2E8CE8', event => {
    event.player.tell(`§2${event.player.username}§r: I think my Questbook has gotten a few more Quests...`)
    event.player.tell(`§2${event.player.username}§r: Lets have a look!`)
    

})
/*
// This is a proof of concept math, if you are working with Minecraft Vectors, you should use their methods to normalize and get the difference as they are faster.
function getVelocity(A, B, mag){
    if(typeof mag != 'number') mag = 1;
    let diff = {x: B.x-A.x, y: B.y-A.y, z: B.z-A.z}; 
    let norm = Math.sqrt((diff.x * diff.x) + (diff.y*diff.y) + (diff.z*diff.z));
    return {x:mag*diff.x/norm,  y:mag*diff.y/norm, z:mag*diff.z/norm};
}

// Debug
ItemEvents.rightClicked('minecraft:debug_stick', event =>{
    const {player, level, server} = event
    const {x, y, z} = player
    let A = {x:x, y:y, z:z};
    let B = {x:0, y: 65, z: 0};
    vel = getVelocity(A,B, 10);
    player.tell(vel);

})

*/
